local PlanetCameras = {
  PlanetMars = {
    point(0, 3398, 30000),
    point(-700, 0, 29900)
  },
  PlanetEarth = {
    point(-334, 2536, 30126),
    point(-472, 2056, 30114)
  },
  PlanetEarthCloseup = {
    point(-571, 1545, 30400),
    point(-683, 1060, 30353)
  }
}

local planet_mars_longitude_offset = -5400
local planet_mars_rotation_speed = 50
local planet_earth_rotation_speed = 250
local planet_earth_close_rotation_speed = 250
local spot_snap_range = 4

local RocketOffsets = {
	ZeusRocket = point(0, -20*guic, 0),
}


-- [CHANGED] Since v4.0 Check if Orion Rocket Mod is used or not.
local o_PlacePlanet = PlacePlanet
function PlacePlanet(scene)
	if not RDM_CheckModLoaded("RDM_ModOrionRocket") then
		o_PlacePlanet(scene)
	else
		
		if IsValid(PlanetObj) then
			DoneObject(PlanetObj)
		end
		if IsValid(PlanetRotationObj) then
			DoneObject(PlanetRotationObj)
		end
		PlayFX("Thrusters", "end", PlanetRocket)
		
		if IsValid(PlanetRocket) then
			DoneObject(PlanetRocket)
		end
		
		if not scene then
			return
		end
		
		local planets = {
			PlanetMars = "PlanetMars",
			PlanetEarth = "PlanetEarth",
			PlanetEarthCloseup = "PlanetEarth"
		}
		local class = planets[scene]
		MapDelete("map", "PlanetDummy", "Rocket")
		local rotation_obj = PlaceObject("PlanetDummy")
		local planet_obj = PlaceObject(class)
		local rocket_obj = false
		rotation_obj:SetPos(0, 0, 300 * guim)
		
		if class == "PlanetMars" then
			rotation_obj:SetState("idle")
			rotation_obj:SetAnimSpeed(1, planet_mars_rotation_speed)
			rotation_obj:SetGameFlags(const.gofBoneTransform)
			local idx = 1
			for _, value in ipairs(MarsScreenLandingSpots or {}) do
			  if value.add_hr_info_onplace then
				hr["PlanetColony" .. idx .. "Longitude"] = value.longitude
				hr["PlanetColony" .. idx .. "Latitude"] = value.latitude
				idx = idx + 1
			  end
			end
			if not PlanetMaxWaterLevel then
				local lower_bound = 300
				PlanetMaxWaterLevel = lower_bound + AsyncRand(1000 - lower_bound)
			end
			SetMaxWaterLevelAndRefresh(PlanetMaxWaterLevel)
			hr.PlanetVegetation = GetTerraformParamPct("Vegetation")
			hr.PlanetAtmosphere = GetTerraformParamPct("Atmosphere")
			hr.PlanetTemperature = GetTerraformParamPct("Temperature")
			local atmosphere = PlaceObject("PlanetClouds")
			rotation_obj:Attach(atmosphere, rotation_obj:GetSpotBeginIndex("Planet"))
			atmosphere:SetScale(101)
			atmosphere:SetOpacity(GetTerraformParamPct("Atmosphere"))
		else
			if class == "PlanetEarth" then
				rotation_obj:SetState("idleSlow")
				rotation_obj:SetAxis(point(-1361, 1113, 3700))
				rotation_obj:SetAngle(5018)
				if scene == "PlanetEarthCloseup" then
					-- [ADDED PART]:start
					-- Permet d'afficher le bon model de la fusée sur la vue RESUPPLY
					local rockets_list = UICity and UICity.labels.AllRockets or empty_table
					local selected_rocket_name = g_RenameRocketObj:GetRocketHyperlink().name[1]
					local rocket_class = false

					
					for _, rocket in ipairs(rockets_list) do 
						if rocket.command == "OnEarth" and rocket.name == selected_rocket_name then
							if IsKindOf(rocket,'RDM_RocketBase') then
								rocket_class = rocket.template_name	
							else
								rocket_class = GetRocketClass()
							end
						end
					end
	 
					if not rocket_class then
						rocket_class = GetRocketClass()
					end
					-- local rocket_class = GetRocketClass()
					-- [ADDED PART]:end
					-- local rocket_class = GetRocketClass()-
					
					local template = BuildingTemplates[rocket_class]
					local rocket_entity = GetMissionSponsor():GetDefaultRocketSkin() or template.entity or "Rocket"
					local clsdef = g_Classes[template.template_class]
					rocket_obj = PlaceObject("Rocket")
					rocket_obj:ClearEnumFlags(const.efCollision + const.efApplyToGrids)
					rocket_obj:ChangeEntity(rocket_entity)
					g_CurrentCCS = UICity and g_CurrentCCS or ColonyColorSchemes[GetMissionSponsor().colony_color_scheme or "default"]
					local palette = GetAdjustedRocketPalette(rocket_obj.entity or "Rocket", clsdef.rocket_palette, GetCurrentColonyColorScheme())
					SetObjectPaletteRecursive(rocket_obj, DecodePalette(palette))
					rocket_obj:SetState("inSpace")
					rocket_obj:DestroyAttaches()
					AutoAttachObjectsToShapeshifter(rocket_obj)
					rocket_obj:SetScale(1)
					rocket_obj:SetGameFlags(const.gofAlwaysRenderable + const.gofRealTimeAnim)
					rocket_obj:SetAxis(point(973, 1217, 3787))
					rocket_obj:SetAngle(-2863)
					rocket_obj:SetPos(point(-563, 1399, 30368) + (RocketOffsets[rocket_entity] or point30))
					local light = PlaceObject("PointLight")
					light:SetAttenuationRadius(10938)
					light:SetIntensity(5)
					light:SetColor(RGB(200, 203, 225))
					rocket_obj:Attach(light)
					light:SetAttachOffset(point(0, 40000, 0))
					PlayFX("Thrusters", "start", rocket_obj)
					rotation_obj:SetAnimSpeed(1, planet_earth_close_rotation_speed)
				else
					rotation_obj:SetAnimSpeed(1, planet_earth_rotation_speed)
				end
			else
			end
		end
		
		rotation_obj:SetGameFlags(const.gofAlwaysRenderable + const.gofRealTimeAnim)
		rotation_obj:Attach(planet_obj, rotation_obj:GetSpotBeginIndex("Planet"))
		planet_obj:SetHeat(255)
		PlanetObj = planet_obj
		PlanetRotationObj = rotation_obj
		PlanetRocket = rocket_obj
	end
end